/*
 * ms5611.c
 *
 *  Created on: Apr 1, 2015
 *      Author: Jordan
 */

#include "ms5611.h"
#include "spi.h"
#include "config.h"
#include "math.h"

// SPI transfer settings
spiDAT1_t spi_ms5611 = {TRUE, FALSE, SPI_FMT_0, SPI_CS_2};

// MS5611 data structure
ms5611_data_t ms5611_data;

void ms5611_init(){
	// Send reset sequence
	uint16 tx = 0x1E;
	spiTransmitData(spiREG1, &spi_ms5611, 1, &tx);
	delay_ms(3);

	// Calibration - pressure sensitivity
	uint16 tx2[3] = {0xA2,0,0};
	uint16 rx[3];
	spiTransmitAndReceiveData(spiREG1, &spi_ms5611, 3, tx2, rx);
	ms5611_data.sens_t1 = rx[1]<<8 | rx[2];

	// Calibration - pressure offset
	tx2[0] = 0xA4;
	spiTransmitAndReceiveData(spiREG1, &spi_ms5611, 3, tx2, rx);
	ms5611_data.off_t1 = rx[1]<<8 | rx[2];

	// Calibration - pressure sensity temperature coefficicent
	tx2[0] = 0xA6;
	spiTransmitAndReceiveData(spiREG1, &spi_ms5611, 3, tx2, rx);
	ms5611_data.tcs = rx[1]<<8 | rx[2];

	// Calibration - pressure offset temperature coefficicent
	tx2[0] = 0xA8;
	spiTransmitAndReceiveData(spiREG1, &spi_ms5611, 3, tx2, rx);
	ms5611_data.tco = rx[1]<<8 | rx[2];

	// Calibration - reference temperature
	tx2[0] = 0xAA;
	spiTransmitAndReceiveData(spiREG1, &spi_ms5611, 3, tx2, rx);
	ms5611_data.t_ref = rx[1]<<8 | rx[2];

	// Calibration - temperature coefficient of temperature
	tx2[0] = 0xAC;
	spiTransmitAndReceiveData(spiREG1, &spi_ms5611, 3, tx2, rx);
	ms5611_data.tempsens = rx[1]<<8 | rx[2];
}

void ms5611_update(){
	// Initiate temperature conversion (OSR = 1024, 2.28 ms)
	uint16 tx = 0x54;
	spiTransmitData(spiREG1, &spi_ms5611, 1, &tx);
	delay_ms(2.5);

	// Obtain temperature ADC value
	uint16 tx2[4] = {0,0,0,0};
	uint16 rx[4];
	spiTransmitAndReceiveData(spiREG1, &spi_ms5611, 4, tx2, rx);
	uint32 temp_adc = ((uint32) rx[1]) << 16 | rx[2] << 8 | rx[3];

	// Calculate compensation parameters
	float32 dT = (float32)temp_adc - (float32)ms5611_data.t_ref*pow(2,8);
	float32 off = (float32)ms5611_data.off_t1*pow(2,16) + (float32)ms5611_data.tco*dT/pow(2,7);
	float32 sens = (float32)ms5611_data.sens_t1*pow(2,15) + (float32)ms5611_data.tcs*dT/pow(2,8);

	// Calculate temperature
	ms5611_data.temperature = (2000 + dT*(float32)ms5611_data.tempsens/pow(2,23))/100;

	// Initiate pressure conversion (OSR = 1024, 2.28 ms)
	tx = 0x44;
	spiTransmitData(spiREG1, &spi_ms5611, 1, &tx);
	delay_ms(2.5);

	// Obtain pressure ADC value
	spiTransmitAndReceiveData(spiREG1, &spi_ms5611, 4, tx2, rx);
	uint32 pres_adc = ((uint32) rx[1]) << 16 | rx[2] << 8 | rx[3];

	// Calculate pressure
	ms5611_data.pressure = ((float32)pres_adc*sens/pow(2,21) - off)/pow(2,15)/100;
}

float32 ms5611_get_temp(){
	return ms5611_data.temperature;
}

float32 ms5611_get_pres(){
	return ms5611_data.pressure;
}

float32 ms5611_get_alt(){
	return (1-pow(ms5611_data.pressure/1013.25,0.190284))*145366.45;
}
